# Manyo/Utsusemiビルド用Dockerイメージ

## ビルド方法
### SPECファイルの準備
GitHubからSPECファイルなどを取得するために、GITHUB_TOKENをセットする必要がある。
GitHubにログインして、右上の自分のアイコン→Settings→Developer settings→Personal access tokens、からアクセストークンを取得する。

    % export GITHUB_TOKEN=xxx
    % ./setup-src.sh

### NeXusおよびmatplotlibをビルドする場合
ディフォルトのDockerfileはmanyo-deps-nexusおよびmanyo-deps-python-matplotlibが存在していることが前提。
それらもビルドする場合はDockerfile-depsを使用すること。

    % docker build -f Dockerfile-deps -t utsusemi-deps-builder .

### 空蝉をビルドする

    % docker build -t utsusemi-builder .

## ビルドされたRPMを取得する
utsusemi-builderイメージを起動し、 `tar` で `/tmp/src/dist` 以下の内容を取得する。
以下のコマンドの場合、カレントディレクトリに `dist` ディレクトリが作成され、
その下にRPMおよびSRPMファイルが生成される。

    % docker run --rm --entrypoint tar utsusemi-builder -C /tmp/src -cf - dist | tar xvf -

