#! /usr/bin/env python
import sys
import os
################################################################################
# Compile script for Manyo-lib release version
#    ver 20170728
#    written by Y. Inamura
#########################################################################
man_script="Usage :     %s <command> [options]\n"%(sys.argv[0])
man_script+="""
       command: [depend/man/make/install/clean]
       options: --debug --help --manyo-path
                --other-modules --numth --pyver
                --rev --without-depend --without-para
  -------------------------------------------------------
  depend  : depend script
  man     : script to make manual
  make    : make
  install : make install
  clean   : make clean

  --debug          : debug mode
  --help           : show this help
  
  --manyo-path=/hoge/hogege/hoge
                   : set MANYO_PATH
  
  --other-modules=SAS,DNA
                   : required other modules if need(default Utsusemi)
  
  --numth=n        : set the number of multi-threading
  --pyver=n.m      : set python version
  --rev=nnnn       : set revision number if need
  --without-depend : does not run depend script
  --without-para   : not use compile option of -j (default use -j)

"""

#########################################################################
#   CXX            : compiler
#   PYVER          : version of python
#   NUM_OF_THREADS : number of threading
#   MANYO_PATH     : path to  manyo-core installed
#   INSTALL_PATH   : path to install
#   OTHER_MANYO_PAC: Other Manyo Package names required by compile
#   ENV_FILE_NAME  : file name of shell script to set Manyo environment 
#   EXT_LIB_ROOT   : root path to external library required by Manyo-lib
#########################################################################
CXX            = "g++"
#PYVER          = "%s.%s"%(sys.version_info[0],sys.version_info[1])
PYVER          = ""
NUM_OF_THREADS = 8
MANYO_PATH     = "/opt/python3/mlfsoft/manyo"
INSTALL_PATH   = MANYO_PATH
OTHER_MANYO_PAC= ["Utsusemi"]
ENV_FILE_NAME  = "bashrc.manyo.release"
EXT_LIB_ROOT   = "/usr/local"

isDebug = False
isWithDepend = True
isCompPara = True
isNotManyoCore = True
utsusemi_rev = 0
#############################################
# Check arguments
#############################################

do_command = ""

#print(sys.argv[2:])
unidentified_args = []
if (len(sys.argv)>1):
    used_args = sys.argv[1:]
    num_of_args = len( used_args )
    ind = 0
    while(True):
        if ind==num_of_args:
            break
        an_arg = used_args[ind]
        ind += 1
        
        if an_arg in ["depend","make","install","clean","man"]:
            do_command = an_arg
        elif an_arg=="--debug":
            isDebug = True
        elif an_arg=="--without-depend":
            isWithDepend = False
        elif an_arg=="--without-para":
            isCompPara = False
        elif an_arg.find("--rev=")==0:
            utsusemi_rev = int(an_arg[6:])
            print("utsusemi_rev = %d"%utsusemi_rev)
        elif an_arg.find("--pyver=")==0:
            PYVER = an_arg[8:].strip()
            print("PYVER= "+PYVER)
        elif an_arg.find("--numth=")==0:
            NUM_OF_THREADS=int(an_arg[8:])
            print("NUM_OF_THREADS= %d"%(NUM_OF_THREADS))
        elif an_arg.find("--manyo-path=")==0:
            MANYO_PATH=an_arg[13:]
            INSTALL_PATH   = MANYO_PATH
            print("MANYO_PATH= "+MANYO_PATH)
            print ("INSTALL_PATH= "+INSTALL_PATH)
        elif an_arg.find("--other-modules=")==0:
            mod_arg = an_arg[16:]
            OTHER_MANYO_PAC = mod_arg.split(",")
            for a_mod in OTHER_MANYO_PAC:
                print("OTHER_MANYO_PAC= "+a_mod)
        elif an_arg.find("--help")==0:
            do_command=""
            break
        else:
            print("Unindentify argument = "+an_arg)
            unidentified_args.append( an_arg )

if (do_command=="") or len(unidentified_args)!=0:
    print(man_script)
    sys.exit(0)

if (do_command=="clean"):
    isWithDepend = False

if (do_command=="make"):
    do_command=""

if os.path.exists( os.path.join( os.getcwd(),"core" ) ):
    isNotManyoCore = False

#############################################
## Check compile target ( manyo-core or not )
#############################################
if isNotManyoCore:
    PACKAGE_NAME=""
    if os.path.exists( os.path.join( os.getcwd(),"Makefile" ) ):
        fo = open( os.path.join( os.getcwd(),"Makefile" ), "r" )
        ll = fo.readlines()
        fo.close()
        for l in ll:
            print(l)
            if l.find("PACKAGE_NAME") is not -1:
                PACKAGE_NAME=l.split("=")[1].strip()
                break
    if PACKAGE_NAME=="":
        print( "Makefile is invalid. (No PACKAGE_NAME)" )
        sys.exit(1)


#########################################################################
## execute make or make install 
#############################################
OTHER_MAN_PAC=["Manyo","MLF"]
for pac in OTHER_MANYO_PAC:
    OTHER_MAN_PAC.append( pac )

EXT_LIB_PATH = os.path.join( EXT_LIB_ROOT,"lib" )
EXT_INC_PATH = os.path.join( EXT_LIB_ROOT,"include" )

com = "export MANYO_PATH=%s;" % (MANYO_PATH)
if isNotManyoCore:
    com += "export INSTALL_PATH=%s;" % (INSTALL_PATH)
    com += "export LIBRARY_PATH=${MANYO_PATH}/lib:${INSTALL_PATH}:%s;" %(EXT_LIB_PATH)
else:
    com += "export LIBRARY_PATH=${MANYO_PATH}/lib:%s;" %(EXT_LIB_PATH)
com += "export LD_LIBRARY_PATH=${LIBRARY_PATH};"
if PYVER!="":
    com += "export C_INCLUDE_PATH=/usr/include/hdf5/serial:/usr/include/python%s:${MANYO_PATH}/include:%s"%(PYVER,EXT_INC_PATH) ## [inamura 161120 for Ubuntu 16.04]
else:
    com += "export C_INCLUDE_PATH=/usr/include/hdf5/serial:${MANYO_PATH}/include:%s"%(EXT_INC_PATH)
for m_pac_name in OTHER_MAN_PAC:
    com += ":${MANYO_PATH}/include/%s"%(m_pac_name)
com += "; "
com += 'export INC_EXT="'
for m_pac_name in OTHER_MAN_PAC:
    com += "%s "%(m_pac_name)
com += '"; '
com += "export CPLUS_INCLUDE_PATH=${C_INCLUDE_PATH};"
com += "export PYTHONPATH=${MANYO_PATH};"
com += "export PATH=${MANYO_PATH}/bin:${PATH};"
if isNotManyoCore and isWithDepend:
    com += "./depend; "

if (do_command!="depend"):
    com += 'make %s '%(do_command)
    if isCompPara:
        com += '-j '
    if PYVER!="":
        com += ' CXX=%s PyVer=%s NUM_MULTH=%d' % (CXX,PYVER,NUM_OF_THREADS)
    else:
        com += ' CXX=%s NUM_MULTH=%d' % (CXX,NUM_OF_THREADS)
    com += ' UTSUSEMI_REV=%d' % (utsusemi_rev)

print("command = "+com)
if isDebug:
    pass
else:
    os.system(com)



#########################################################################
## make environ file
#############################################

env_list = []
env_list.append( '#!/bin/bash' )
env_list.append( 'export MANYO_PATH=%s' % (MANYO_PATH) )

if isNotManyoCore and (MANYO_PATH!=INSTALL_PATH):
    env_list.append( 'export INSTALL_PATH=%s' % (INSTALL_PATH) )
    env_list.append( 'export LD_LIBRARY_PATH=${MANYO_PATH}/lib:${INSTALL_PATH}/%s/lib:${LD_LIBRARY_PATH}' % (PACKAGE_NAME) )
    env_list.append( 'export PYTHONPATH=${MANYO_PATH}:${INSTALL_PATH}/Manyo/%s:${PYTHONPATH}' % (PACKAGE_NAME) )
else:
    env_list.append( 'export LD_LIBRARY_PATH=${MANYO_PATH}/lib:${LD_LIBRARY_PATH}' )
    env_list.append( 'export PYTHONPATH=${MANYO_PATH}:${PYTHONPATH}' )
env_list.append( 'export PATH=${MANYO_PATH}/bin:$PATH' )


if isDebug:
    for an_env in env_list:
        print( an_env )
else:
    fo = open( os.path.join( os.getcwd(),ENV_FILE_NAME ), 'w' )
    for ss in env_list:
        fo.write(ss+'\n')
    fo.close()


