# -*- coding: utf-8 -*-
"""

"""

import utsusemi.vis.VisualModuleQBase as UVM
import utsusemi.SAS.vis.UBSlicer as UBS
# 予約語の定義
ret = None
vp1 = None
vp2 = None
vp3 = None
vc = None
vc2 = None
vc3 = None
ec = None
earray = None
DAT = None
ECM = None
ECA = None
vcm = None

###################################################
def DetectMap(matrix=DAT):
        """
        Display Detector Map
        @param  matrix [Def:DAT(ElementContainerMatrix)] ElementContainerMatrix Object
        @retval vp3
        """
        return UVM.DetectMap(matrix)

###################################################
def DetectMapChangeData(vp3=vp3,matrix=DAT):
        """
        Display Detector Map
        @param  matrix [Def:DAT(ElementContainerMatrix)] ElementContainerMatrix Object
        @retval vp3
        """
        UVM.DetectMapChangeData(vp3,matrix)

###################################################
def MPlot(ec=ec):
        """
        Create 1D Plotter and Draw EC
        @param  ec [Def:EC(ElementContainer,ListOfEC)]  ElementContainer
        @param  psd      PSD No.
        @param  pixel    Pixel No.
        @retval vp1    Instance of Plotter
        """
        return UVM.MPlot(ec)

###################################################
def AddToMPlot(vp1=vp1, ec=ec):
        """
        Add EC to 1D Plotter
        @param  vp1 [Def:(vis_retval)]     Instance of 1D Plotter
        @param  ec [Def:EC(ElementContainer)]      ElementContainer
        @retval None
        """
        UVM.AddToMPlot(vp1,ec)

###################################################
def EmptyMPlot():
        """
        Create 1D Plotter and Draw EC without data
        @param  None
        @retval vp1 [Def:vp1] Instance of Plotter
        """
        return UVM.MPlot(None)

###################################################
def M2PlotPlus(matrix=ECA):
        """
        Create 2D Plotter and display 2D Map
        @param  matrix [Def:ECA(ElementContainerArray,ElementContainerMatrix)]  ElementContainerArray, -Matrix
        @retval vp2 [Def:vp2]  Instance of 2D Plotter
        """
        return UVM.M2PlotPlus(matrix)

###################################################
def ChangeDataM2Plot(vp2=vp2, matrix=ECA):
        """
        Change 2D Map of M2Plot
	@param  vp2 [Def:(vis_retval)]     Instance of 2D Plotter
        @param  matrix [Def:ECA(ElementContainerArray,ElementContainerMatrix)]  ElementContainerArray
        @retval None
        """
        UVM.ChangeDataM2Plot(vp2, matrix)

###################################################
def UBSlicer(dat=DAT):
        """
        UBSlicer
        @param  dat [Def:DAT(ElementContainerMatrix)] ElementContainerMatrix
        @retval ubs
        """
        return UBS.UBSlicerFrame(dat,None)

# 関数名登録ディクショナリ
_functions = {"DetectMap":DetectMap,
              "MPlot":MPlot,
              "AddToMPlot":AddToMPlot,
              "EmptyMPlot":EmptyMPlot,
              "M2PlotPlus":M2PlotPlus,
	      "ChangeDataM2Plot":ChangeDataM2Plot,
              "UBSlicer":UBSlicer
	      }

_functionsOrder = [
	"DetectMap",
	"MPlot",
	"AddToMPlot",
        "EmptyMPlot",
	"M2PlotPlus",
	"ChangeDataM2Plot",
	"UBSlicer"
	]

