#!/usr/bin/python3
# -*- coding: utf-8 -*-

import sys
import utsusemi.SAS.ana.Reduction.TransBaseCommands as TBC
import Manyo as mm
import Manyo.SAS as ms

# reserved words for return value in this.
DAT = None
ecs = None
EC = None
ret = None
PyObj = None
Iq = None
Tr = None


#########################################                                
def GetTransNormByMonCounts(SmplRunNo="104000", DrctRunNo="104000", AxType="lambda", XRange="0.7 7.6 0.1", frameBoundary=0.0, CalibEffi=True ):
    """
    Monitor histogram of sample and direct followed by a transmittance calculation.
    @param SmplRunNo     (string)    Sample measurement run number
    @param DrctRunNo     (string)    Direct beam measurement run number
    @param AxType        (string)  Type must be "tof', "lambda" or "lamda2"
    @param XRange        (string) "startX endX widthX" separated with space (not comma)
    @param frameBoundary (float)
    @param CalibEffi     (bool)    Monitor-detector efficiency calibration
    @retval Tr
    """
    return TBC.GetTransNormByMonCounts(SmplRunNo, DrctRunNo, AxType, XRange, frameBoundary, CalibEffi)

#########################################                                
def GetTransNormByMonCountsTS(SmplRunNo="104000", DrctRunNo="104000", AxType="lambda", XRange="0.7 7.6 0.1", frameBoundary=0.0, CalibEffi=True, SmplTSlice="-1 -1", DrctTSlice="-1 -1"):
    """
    Monitor histogram of sample and direct followed by a transmittance calculation.
    @param SmplRunNo     (string)    Sample measurement run number
    @param DrctRunNo     (string)    Direct beam measurement run number
    @param AxType        (string)  Type must be "tof', "lambda" or "lamda2"
    @param XRange        (string) "startX endX widthX" separated with space (not comma)
    @param frameBoundary (float)
    @param CalibEffi     (bool)    Monitor-detector efficiency calibration
    @param SmplTSlice    (string) Time Slice parameters for Sample run
    @param DrctTSlice    (string) Time Slice parameters for Directrun
    @retval Tr
    """
    return TBC.GetTransNormByMonCountsTS(SmplRunNo, DrctRunNo, AxType, XRange, frameBoundary, CalibEffi, SmplTSlice, DrctTSlice )

#########################################
def GetTransNormByMon(SmplRunNo="104000", DrctRunNo="104000", Xrange="0.7 7.6 0.1 dL", frameBoundary="0.0", CalibEffi=True, useMon="MON1" ):
    """
    Monitor histogram of sample and direct followed by a transmittance calculation.
    @param SmplRunNo     (string)    Sample measurement run number
    @param DrctRunNo     (string)    Direct beam measurement run number
    @param Xrange        (string)  "startX endX widthX type" separated with space (not comma) : type=[dL, dL/L, tof]
    @param frameBoundary (float)
    @param CalibEffi     (bool)    Monitor-detector efficiency calibration
    @param useMon        (strng)  Upstream Monitor (MON1 or MON3)
    @retval Tr
    """
    return TBC.GetTransNormByMon(SmplRunNo, DrctRunNo, Xrange, frameBoundary, CalibEffi, useMon )

#########################################
def GetTransNormByMonTS(SmplRunNo="104000", DrctRunNo="104000", Xrange="0.7 7.6 0.1 dL", frameBoundary="0.0", CalibEffi=True, SmplTSlice="-1 -1", DrctTSlice="-1 -1", useMon="MON1", paramFiles="- -"):
    """
    Monitor histogram of sample and direct followed by a transmittance calculation.
    @param SmplRunNo     (string)    Sample measurement run number
    @param DrctRunNo     (string)    Direct beam measurement run number
    @param Xrange        (string)  "startX endX widthX type" separated with space (not comma) : type=[dL, dL/L, tof]
    @param frameBoundary (float)
    @param CalibEffi     (bool)    Monitor-detector efficiency calibration
    @param SmplTSlice    (string) Time Slice parameters for Sample run
    @param DrctTSlice    (string) Time Slice parameters for Directrun
    @param useMon        (strng)  Upstream Monitor (MON1 or MON3)
    @param paramFiles    (string) "<wiringInfo> <detectorInfo>[ <caseInfo>]
    @retval Tr
    """
    return TBC.GetTransNormByMonTS(SmplRunNo, DrctRunNo, Xrange, frameBoundary, CalibEffi, SmplTSlice, DrctTSlice, useMon, paramFiles)


# Dictionary for entry the name of functions
_functions = {
            "GetTransNormByMonCounts":GetTransNormByMonCounts,
            "GetTransNormByMonCountsTS":GetTransNormByMonCountsTS,
            "GetTransNormByMon":GetTransNormByMon,
            "GetTransNormByMonTS":GetTransNormByMonTS,
            }
