#! /usr/bin/env python
################################################################################
# Compile script for Manyo-lib release version
#    ver 20140123
#    written by Y. Inamura
#########################################################################
# Required parameters
#   CXX            : compiler
#   PYVER          : version of python
#   NUM_OF_THREADS : number of threading
#   MANYO_PATH     : path to  manyo-core installed
#   INSTALL_PATH   : path to install
#   OTHER_MANYO_PAC: Other Manyo Package names required by compile
#   ENV_FILE_NAME  : file name of shell script to set Manyo environment 
#   EXT_LIB_ROOT   : root path to external library required by Manyo-lib
#########################################################################
CXX            = "g++44"
PYVER          = "2.4"
NUM_OF_THREADS = 8
MANYO_PATH     = "/opt/mlfsoft/manyo"
INSTALL_PATH   = MANYO_PATH
OTHER_MANYO_PAC= ["Utsusemi"]
ENV_FILE_NAME  = "bashrc.manyo.release"
EXT_LIB_ROOT   = "/usr/local"
#########################################################################


#########################################################################
## Set Environment
############################################
import sys
import os

isDebug = False
isWithDepend = True
isCompPara = True
isNotManyoCore = True

#############################################
# Check arguments
#############################################
#print sys.argv
do_command = ""
if (len(sys.argv)>1):
    if sys.argv[1] in ["depend","make","install","clean","man"]:
        do_command = sys.argv[1]


#print sys.argv[2:]
if (len(sys.argv)>2):
    for an_arg in sys.argv[2:]:
        if an_arg=="debug":
            isDebug = True
        if an_arg=="--without-depend":
            isWithDepend = False
        if an_arg=="--without-para":
            isCompPara = False

if (do_command==""):
    print "Usage : python <this script> <command> [options]"
    print ""
    print "       command: depend"
    print "                man"
    print "                make"
    print "                install"
    print "                clean"
    print ""
    print "       options: debug"
    print "                --without-depend"
    print "                --without-para"
    sys.exit(0)

if (do_command=="clean"):
    isWithDepend = False

if (do_command=="make"):
    do_command=""

if os.path.exists( os.path.join( os.getcwd(),"core" ) ):
    isNotManyoCore = False

#############################################
## Check compile target ( manyo-core or not )
#############################################
if isNotManyoCore:
    PACKAGE_NAME=""
    if os.path.exists( os.path.join( os.getcwd(),"Makefile" ) ):
        fo = open( os.path.join( os.getcwd(),"Makefile" ), "r" )
        ll = fo.readlines()
        fo.close()
        for l in ll:
            print l
            if l.find("PACKAGE_NAME") is not -1:
                PACKAGE_NAME=l.split("=")[1].strip()
                break
    if PACKAGE_NAME=="":
        print( "Makefile is invalid. (No PACKAGE_NAME)" )
        sys.exit(1)


#########################################################################
## execute make or make install 
#############################################
EXT_LIB_PATH = os.path.join( EXT_LIB_ROOT,"lib" )
EXT_INC_PATH = os.path.join( EXT_LIB_ROOT,"include" )

com = "export MANYO_PATH=%s;" % (MANYO_PATH)
if isNotManyoCore:
    com += "export INSTALL_PATH=%s;" % (INSTALL_PATH)
    com += "export LIBRARY_PATH=${MANYO_PATH}/lib:${INSTALL_PATH}:%s;" %(EXT_LIB_PATH)
else:
    com += "export LIBRARY_PATH=${MANYO_PATH}/lib:%s;" %(EXT_LIB_PATH)
com += "export LD_LIBRARY_PATH=${LIBRARY_PATH};"
com += "export C_INCLUDE_PATH=/usr/include/python%s:${MANYO_PATH}/include:%s"%(PYVER,EXT_INC_PATH)
for m_pac_name in OTHER_MANYO_PAC:
    com += ":${MANYO_PATH}/include/%s"%(m_pac_name)
com += "; "
com += "export CPLUS_INCLUDE_PATH=${C_INCLUDE_PATH};"
com += "export PYTHONPATH=${MANYO_PATH};"
com += "export PATH=${MANYO_PATH}/bin:${PATH};"
if isNotManyoCore and isWithDepend:
    com += "./depend; "

if (do_command!="depend"):
    com += 'make %s '%(do_command)
    if isCompPara:
        com += '-j '
    com += ' CXX=%s PyVer=%s NUM_MULTH=%d' % (CXX,PYVER,NUM_OF_THREADS)

print "command = ",com
if isDebug:
    pass
else:
    os.system(com)



#########################################################################
## make environ file
#############################################

env_list = []
env_list.append( '#!/bin/bash' )
env_list.append( 'export MANYO_PATH=%s' % (MANYO_PATH) )

if isNotManyoCore and (MANYO_PATH!=INSTALL_PATH):
    env_list.append( 'export INSTALL_PATH=%s' % (INSTALL_PATH) )
    env_list.append( 'export LD_LIBRARY_PATH=${MANYO_PATH}/lib:${INSTALL_PATH}/%s/lib:${LD_LIBRARY_PATH}' % (PACKAGE_NAME) )
    env_list.append( 'export PYTHONPATH=${MANYO_PATH}:${INSTALL_PATH}/Manyo/%s:${PYTHONPATH}' % (PACKAGE_NAME) )
else:
    env_list.append( 'export LD_LIBRARY_PATH=${MANYO_PATH}/lib:${LD_LIBRARY_PATH}' )
    env_list.append( 'export PYTHONPATH=${MANYO_PATH}:${PYTHONPATH}' )
env_list.append( 'export PATH=${MANYO_PATH}/bin:$PATH' )


if isDebug:
    print env_list
else:
    fo = open( os.path.join( os.getcwd(),ENV_FILE_NAME ), 'w' )
    for ss in env_list:
        fo.write(ss+'\n')
    fo.close()


