#include "ConvertToPoint.hh"
//////////////////////////////////////////////////////////
ConvertToPoint::
ConvertToPoint()
{
    Initialize();
}

//////////////////////////////////////////////////////////
ConvertToPoint::
ConvertToPoint( ElementContainerMatrix *ecm )
{
    Initialize();
    SetTarget( ecm );
}

//////////////////////////////////////////////////////////
ConvertToPoint::
~ConvertToPoint()
{
    delete UCP;
}
//////////////////////////////////////////////////////////
void ConvertToPoint::
Initialize(){
    UCP = new UtsusemiCheckDataProcess();
    _MessageTag = "SAS_ConvertToPoint::";
    _ProcessTag = "ConvertToPoint";
}
//////////////////////////////////////////////////////////
void ConvertToPoint::
Execute( bool isReverse )
{
    ElementContainerMatrix* ecm = Put();

    if (isReverse){
        if (!(UCP->CheckProcess( ecm,_ProcessTag ))){
            std::cout << _MessageTag << "Execute : never done ConvertToPoint or already reversed" << std::endl;
            return;
        }
    }else{
        if (UCP->CheckProcess( ecm,_ProcessTag )){
            std::cout << _MessageTag << "Execute : already done ConvertToPoint" << std::endl;
            return;
        }
    }

    for (UInt4 i=0; i<ecm->PutSize(); i++){
        ElementContainerArray* eca = ecm->PutPointer(i);

        for (UInt4 j=0; j<eca->PutSize(); j++){
            ElementContainer* ec = eca->PutPointer(j);

            std::vector<Double> Xbin = ec->PutX();
            std::vector<Double> Intensity = ec->PutY();
            std::vector<Double> Errors = ec->PutE();
            std::string Xkey = ec->PutXKey();
            std::string Ykey = ec->PutYKey();
            std::string Ekey = ec->PutEKey();

            for (UInt4 k=0; k<Intensity.size(); k++){
                Double bin_width = Xbin[k+1]-Xbin[k];
                if (isReverse){
                    Intensity[k] = Intensity[k]*bin_width;
                    Errors[k] = Errors[k]*bin_width;
                }else{
                    Intensity[k] = Intensity[k]/bin_width;
                    Errors[k] = Errors[k]/bin_width;
                }
            }

            ec->Replace( Ykey, Intensity );
            ec->Replace( Ekey, Errors );
            ec->SetKeys( Xkey, Ykey, Ekey );
        }
    }

    if (isReverse){
        UCP->RemoveProcess( ecm, _ProcessTag );
    }else{
        UCP->AddProcess( ecm, _ProcessTag );
    }
}
