#ifndef SASCALCSCANTRAJECTORY
#define SASCALCSCANTRAJECTORY

#include "UtsusemiHeader.hh"
#include "UtsusemiUnitConverter.hh"
#include "CppToPython.hh"
#include "ElementContainerMatrix.hh"
#include "ElementContainerArray.hh"
#include "ElementContainer.hh"
#include "StringTools.hh"

////////////////////////////////////////
// SAS::CalcScanTrajectory
////////////////////////////////////////

//! Calculates scan trajectory for SAS
/*!
 *  Bank = "SM SC"
 *  Lambda_list = [ 0.7, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0 ]
 *  Q_ela_min = 0.1
 *  Q_ela_max = 1.0
 *  Q_bin = 0.01
 *  Q_plotrange_min = 0.0
 *  Q_plotrange_max = 4.0
 *  hw_delta = 0.05
 *  DAT = Hist3.GetHistogramSAS(runNo="0",Xrange="0.7 7.6 0.1 dL",Bank=Bank,
 *                              TimeSlice="-1 -1",frameBoundary="0.0",isTimeFoc=False,SolAngCor=True,paramFiles="- -")
 *  tt = ms.CalcScanTrajectory(DAT)
 *  tt.SetQPlotRange( Q_plotrange_min, Q_plotrange_max)
 *  tt.SetHWbin( hw_delta )
 *  tt.SetLambdaList( Lambda_list )
 *  ECA = Manyo.ElementContainerArray()
 *  tt.Execute( ECA, Q_ela_min, Q_ela_max, Q_bin )
 */

class CalcScanTrajectory :
    public ManipulatorBase< ElementContainerMatrix >
{

private:
    double _Q_plotrange_min;
    double _Q_plotrange_max;
    std::vector<double> _lamb_list;
    double _hw_min;
    double _hw_bin;
    StringTools* _st;
    void _initialize();

public:
    CalcScanTrajectory();
    CalcScanTrajectory(ElementContainerMatrix*);

    ~CalcScanTrajectory();

    void SetQPlotRange( double Q_plotrange_min = 0.0, double Q_plotrange_max=4.0 );
    void SetHWmin( double hw_min=-100.0 );
    bool SetHWbin( double hw_bin = 0.1 );
    bool SetLambdaList( std::vector<Double> lamb_list );
    bool SetLambdaList( PyObject *lamb_pylist );
    bool Execute( ElementContainerArray* eca, double Qela_min, double Qela_max, double Qela_bin );


};
#endif
