from __future__ import print_function

import sys
import Manyo as mm
import Manyo.Utsusemi as mu
import Manyo.Emaki as me

if len(sys.argv) !=4:
    print("Usage: %s run_number wiring_info detector_info"%sys.argv[0])
    print("Note:")
    print("")
    sys.exit()

RunNumber = int(sys.argv[1])
Wfile = sys.argv[2]
Dfile = sys.argv[3]
InstCode = 'ENG'
DataPath = '/data'
output_path = "%s%06d.srlz"%(InstCode, RunNumber)

evt = me.EmakiEventDataConverterReadout1d()
evt.LoadParamFiles( Wfile, Dfile )
evt.SetHistAllocation()
ecm = mm.ElementContainerMatrix()
evt.SetElementContainerMatrix( ecm, RunNumber, DataPath )

boostWrite = mm.WriteSerializationFileBinary(output_path)
boostWrite.Save(ecm)
print("[o] Histograms were serialized to %s."%output_path)

