#!/usr/bin/python
# -*- coding: utf-8 -*-

import time
import os
import Manyo as mm
import math

import utsusemi.DNA.ana.Reduction.BaseCommandsDNA as BaseComDNA
import utsusemi.DNA.ana.Reduction.RockingCurve as RC

# special reserved word for commands history
HISTORY = None

# reserved words for return value in this.
DAT = None
ecs = None
EC = None
ret = None
ECA = None

#########################################
def DNAQSlice2D(ecm, Qxzc=-0.1, Qyc=-0.1 ,dQ=0.05):
    """
    @param ecm  (ElementContainerMatrix)
    @param Qxzc (double) Center on Qxz axis 
    @param Qyc  (double) Center on Qy axis
    @param dQ   (double) with of Q
    @retval EC  (ElementContainer)
    """
    EC = RC.DNAQSlice2D(ecm,Qxzc,Qyc,dQ)
    return EC

#########################################
#T. Yamada [130125]
def DNAmakeAngle2D(ecm, Theta2xzmin = -180.0,Theta2xzmax = 180.0,dTheta2xz = 4.0, ElevAnglemin=-20.0, ElevAnglemax = 20.0, dElevAngle = 0.5):
	"""
	Get 2D Map (2Theta in xz plane and Elevation Angle between Y axis and xz plane)
	@param ecm	(ElementContainerMatrix)
	@param Theta2xzmin	(double)	Minimum of Theta2xz [Degree]
	@param Theta2xzmax	(double)	Max of Theta2xz [Degree]
	@param dTheta2xz	(double)	delta Theta2xz [Degree]
	@param ElevAnglemin	(double)	Minimum of Elevation Angle [Degree]
	@param ElevAnglemax	(double)	Max of Elevation Angle [Degree]
	@param dElevAngle	(double)	delta  Elevation Angle [Degree]
	@retval ECA      (ElementContainerArray) The intensity is integrated in all energy transfer range of ecm
	
	The positive range in Theta2xz is BL01 side.
	"""
	ECA = RC.DNAmakeAngle2D(ecm, Theta2xzmin,Theta2xzmax,dTheta2xz, ElevAnglemin, ElevAnglemax, dElevAngle)
	return ECA
	
#########################################
#T. Yamada[130125]
def DNAmakeQE2D(ecm, Qxzmin=-2.0,Qxzmax=2.0,dQxz=0.05,Qymin=-0.3,Qymax=0.4,dQy=0.02):
	"""
	Get 2D Map (Qxy and Qy)
	@param ecm	(ElementContainerMatrix)
	@param Qxzmin	(double)	Minimum of Qxz [1/A]
	@param Qxzmax	(double)	Max of Qxz [1/A]
	@param dQxz	(double)	delta Qxz [1/A]
	@param Qymin	(double)	Minimum of Qy [1/A]
	@param Qymax	(double)	Max of Qy [1/A]
	@param dQy	(double)	delta Qy [1/A]
	@retval ECA      (ElementContainerArray) The intensity is integrated in all energy transfer range of ecm
	
	The positive range in Qxz is BL01 side.
	"""
	ECA = RC.DNAmakeQE2D(ecm, Qxzmin,Qxzmax,dQxz,Qymin,Qymax,dQy)
	
	return ECA
#########################################
#T.Yamada Add[130118]
def DNAGetRockingCurve(StartEndRunNo="",StartEndpsd="",StartEndPix=" ",LambdaParam="",mode=111,startomega=0.0,domega=0.5,OmgPlot=True):
    """
    Get rocking curver
    TYGetRockingCurve(StartEndRunNo=" ",StartEndpsd=" ",StartEndPix=" ",
                        LambdaParam="",mode=111,startOmega=0.0,domega=0.5,OmgPlot=True):
    @param StartEndRunNo (string) start and end runNo
    @param StartEndpsd (string) start and end psd
    @param StartEndPix (string) start and end pixel
    @param LambdaParam (string) lambda center and delta lambda
    @param mode (ing) select Si analyzer 111 or 333
    @param startOmega (double) start omega [deg]
    @param domega (double) delta omega [deg]
    @param output (bool) output as omega (True) or runNo (False)
    @retval EC      (ElementContainer)
    """
    return BaseComDNA.DNAGetRockingCurve(StartEndRunNo,StartEndpsd,StartEndPix,LambdaParam,mode,startomega,domega,OmgPlot)    
#########################################

# Dictionary for entry the name of functions
_functions = {
              "DNAQSlice2D":DNAQSlice2D,
              "DNAGetRockingCurve":DNAGetRockingCurve,
              "DNAmakeAngle2D":DNAmakeAngle2D,
              "DNAmakeQE2D":DNAmakeQE2D
	      }
