#!/usr/bin/python
# -*- coding: utf-8 -*-

import utsusemi.DNA.ana.Reduction.AbsorptionCorrection   as ACR
import utsusemi.DNA.ana.Reduction.EfficiencyCorrection   as EFC
import utsusemi.DNA.ana.Reduction.EnergyOriginCorrection as EOC
import utsusemi.DNA.ana.Reduction.PylabPlotTools         as PPT
import utsusemi.DNA.ana.Reduction.SearchPathDNA          as SPD
import os
# special reserved word for commands history
HISTORY = None

# reserved words for return value in this.
DAT = None
ecs = None
EC  = None
ret = None
ECA = None
ECM = None
ECM1 = None
ECM2 = None
VAL  = None
###################################################################################################
# Energy Origin Correction
###################################################################################################
def MovingAverage(dat=DAT,sample=2):
    """
    MovingAverage
    @retval ECM     (ElementContainerMatrix)
    """
    ECM = EOC.MovingAverage(dat,sample)
    return ECM
#--------------------------------------------------------------------------------------------------
def CalcTOFOffset(dat=ECM, energyRange="-0.1,0.1",energyLimit="-1.0,-1.0",peakLimit="-1.0,-1.0",
                       outputFilename="tofOffset.eorg", failedFilename="failedData.txt"):
    """
    CalcTOFOffset
    @retval None
    """
    try:
        energyMin, energyMax = energyRange.split(",")
        energyMin      = float(energyMin)
        energyMax      = float(energyMax)
    except:
        energyMin      = float(-1.0)
        energyMax      = float(1.0)
    try:
        energyLimitMin, energyLimitMax = energyLimit.split(",")
        energyLimitMin = float(energyLimitMin)
        energyLimitMax = float(energyLimitMax)
    except:
        energyLimitMin = float(-1.0)
        energyLimitMax = float(-1.0)
    try:
        peakLimitMin, peakLimitMax     = peakLimit.split(",")
        peakLimitMin   = float(peakLimitMin)
        peakLimitMax   = float(peakLimitMax)
    except:
        peakLimitMin   = float(-1.0)
        peakLimitMax   = float(-1.0)

    #outputFilename = os.path.join(os.sep,"home","dnaadmin","ana","EOrg",outputFilename)
    #failedFilename = os.path.join(os.sep,"home","dnaadmin","ana","EOrg",failedFilename)
    #outputFilename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","EOrg",outputFilename)
    #failedFilename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","EOrg",failedFilename)
    outputFilename_dir = SPD.CheckForOutput("EOrg")
    if outputFilename!="":
        outputFilename = os.path.join( outputFilename_dir, outputFilename )
        failedFilename = os.path.join( outputFilename_dir, failedFilename )
    else:
        raise UserWarning("EneOrig::CalcTOFOffset >> EOrg dir is not found.")

    return EOC.CalcTOFOffset(dat, energyMin, energyMax, energyLimitMin, energyLimitMax,
                       peakLimitMin, peakLimitMax, outputFilename, failedFilename)
###################################################################################################
# Energy Origin Correction (assist)
###################################################################################################
def PutValArray(ec,energyMin,energyMax):
    """
    PutValArray
    """
    return EOC.PutValArray(ec,energyMin,energyMax)
#--------------------------------------------------------------------------------------------------
def EstimateFittingInitial(x,y):
    """
    EstimateFittingInitial
    """
    return EOC.EstimateFittingInitial(x,y)
#--------------------------------------------------------------------------------------------------
def ExecGaussFit(xarray,yarray,guess):
    """
    ExecGaussFit
    """
    return EOC.ExecGaussFit(xarray,yarray,guess)
#--------------------------------------------------------------------------------------------------
def GaussFunction(x,height,center,sigma,constant):
    """
    GaussFunction
    """
    return EOC.GaussFunction(x,height,center,sigma,constant)
#--------------------------------------------------------------------------------------------------
def ExecGaussFitEC(ec=EC,energyMin=-0.1,energyMax=0.1,height=-1.0,center=-1.0,sigma=-1.0,back=-1.0):
    """
    ExecGaussFitEC
    @retval DAT
    """
    DAT = EOC.ExecGaussFitEC(ec,energyMin,energyMax,height,center,sigma,back)
    return DAT
###################################################################################################
# Absorption Correction (create coefficient file)
###################################################################################################
def CalcASS(eiArray="1.5,2.0,2.5,3.0,3.5,4.0", sampleFileName="MMNi.dat", degree=4,
                                                output="out.ass", laticeSpace=3.134600, alpha=1.0):
    """
    CalcASS
    @retval None
    """
    if os.path.exists(sampleFileName):
        pass
    else:
        #sampleFileName = os.path.join(os.sep,"home","dnaadmin","ana","setup",sampleFileName)
        #sampleFileName = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup",sampleFileName)
        ret = SPD.CheckForInput( "setup", sampleFileName )
        if ret=="":
            raise UserWarning("CalcASS >> sampleFileName does not found (%s)"%(sampleFileName))
        else:
            sampleFileName = ret
    #output = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",output)
    #output = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",output)
    #ret = SPD.CheckForOutput( "Absorb", output )
    ret = SPD.CheckForOutput( "Absorb" )
    if ret=="":
        raise UserWarning("CalcASS >> output does not found (%s)"%(output))
    else:
        output = os.path.join(os.sep, ret, output )

    eiArray = [float(val) for val in eiArray.split(",")]

    return ACR.CalcASS(eiArray, sampleFileName ,degree, output, laticeSpace, alpha)
#--------------------------------------------------------------------------------------------------
def CalcACSC(eiArray="1.5,2.0,2.5,3.0,3.5,4.0", sampleFileName="MMNi.dat", degree=4,
                                               output="out.acsc", laticeSpace=3.134600, alpha=1.0):
    """
    CalcACSC
    @retval None
    """
    if os.path.exists(sampleFileName):
        pass
    else:
        #sampleFileName = os.path.join(os.sep,"home","dnaadmin","ana","setup",sampleFileName)
        #sampleFileName = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup",sampleFileName)
        ret = SPD.CheckForInput( "setup", sampleFileName )
        if ret=="":
            raise UserWarning("CalcACSC >> sampleFileName does not found (%s)"%(sampleFileName))
        else:
            sampleFileName = ret
    #output = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",output)
    #output = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",output)
    ret = SPD.CheckForOutput( "Absorb" )
    if ret=="":
        raise UserWarning("CalcACSC >> output does not found (%s)"%(output))
    else:
        output = os.path.join(os.sep, ret, output )

    eiArray = [float(val) for val in eiArray.split(",")]

    return ACR.CalcACSC(eiArray, sampleFileName ,degree, output, laticeSpace, alpha)
#--------------------------------------------------------------------------------------------------
def CalcACSS(eiArray="1.5,2.0,2.5,3.0,3.5,4.0", sampleFileName="MMNi.dat", degree=4,
                                               output="out.acss", laticeSpace=3.134600, alpha=1.0):
    """
    CalcACSS
    @retval None
    """
    if os.path.exists(sampleFileName):
        pass
    else:
        #sampleFileName = os.path.join(os.sep,"home","dnaadmin","ana","setup",sampleFileName)
        #sampleFileName = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup",sampleFileName)
        ret = SPD.CheckForInput( "setup", sampleFileName )
        if ret=="":
            raise UserWarning("CalcACSS >> sampleFileName does not found (%s)"%(sampleFileName))
        else:
            sampleFileName = ret
    #output = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",output)
    #output = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",output)
    ret = SPD.CheckForOutput( "Absorb" )
    if ret=="":
        raise UserWarning("CalcACSS >> output does not found (%s)"%(output))
    else:
        output = os.path.join(os.sep, ret, output )
        #output = ret

    eiArray = [float(val) for val in eiArray.split(",")]

    return ACR.CalcACSS(eiArray, sampleFileName ,degree, output, laticeSpace, alpha)
#--------------------------------------------------------------------------------------------------
def CalcACC(eiArray="1.5,2.0,2.5,3.0,3.5,4.0", sampleFileName="MMNi.dat", degree=4, 
                                                output="out.acc", laticeSpace=3.134600, alpha=1.0):
    """
    CalcACCC
    @retval None
    """
    if os.path.exists(sampleFileName):
        pass
    else:
        #sampleFileName = os.path.join(os.sep,"home","dnaadmin","ana","setup",sampleFileName)
        #sampleFileName = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup",sampleFileName)
        ret = SPD.CheckForInput( "setup", sampleFileName )
        if ret=="":
            raise UserWarning("CalcACC >> sampleFileName does not found (%s)"%(sampleFileName))
        else:
            sampleFileName = ret
    #output = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",output)
    #output = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",output)
    ret = SPD.CheckForOutput( "Absorb" )
    if ret=="":
        raise UserWarning("CalcACC >> output does not found (%s)"%(output))
    else:
        output = os.path.join(os.sep, ret, output )
        #output = ret

    eiArray = [float(val) for val in eiArray.split(",")]

    return ACR.CalcACC(eiArray, sampleFileName ,degree, output, laticeSpace, alpha)
#--------------------------------------------------------------------------------------------------
def CalcASSOfElastic(sampleFileName="MMNi.dat", output="out.ele", laticeSpace=3.134600, alpha=1.0):
    """
    CalcASSOfElastic
    @retval None
    """
    if os.path.exists(sampleFileName):
        pass
    else:
        #sampleFileName = os.path.join(os.sep,"home","dnaadmin","ana","setup",sampleFileName)
        #sampleFileName = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup",sampleFileName)
        ret = SPD.CheckForInput( "setup", sampleFileName )
        if ret=="":
            raise UserWarning("CalcASSOfElastic >> sampleFileName does not found (%s)"%(sampleFileName))
        else:
            sampleFileName = ret
    #output = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",output)
    #output = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",output)
    ret = SPD.CheckForOutput( "Absorb" )
    if ret=="":
        raise UserWarning("CalcACCOfElastic >> output does not found (%s)"%(output))
    else:
        output = os.path.join(os.sep, ret, output )
        #output = ret

    return ACR.CalcASSOfElastic(sampleFileName, output, laticeSpace, alpha)
#--------------------------------------------------------------------------------------------------
def ReadAbsorptionCoefficientFileOfElastic(filename):
    """
    ReadAbsorptionCoefficientFileOfElastic
    """

    if os.path.exists(filename):
        pass
    else:
#        filename = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",filename)
        #filename = os.path.join(os.sep,"home","dnaadmin","ana","EOrg",filename)
        #filename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","EOrg",filename)
        ret= SPD.CheckForInput("EOrg", filename)
        if ret!="":
            filename = ret
        else:
            raise UserWarning("EneOrig::ReadAbsorptionCoefficientFileOfElastic >> EOrg dir is not found.")

    return ACR.ReadAbsorptionCoefficientFileOfElastic(filename)
###################################################################################################
# Absorption Correction (assist)
###################################################################################################
def CalcAbsorptionCoeff(mode="ASS", eiArray="1.5,2.0,2.5,3.0,3.5,4.0", ef = 2.08, aa=0.26, pa=1.84,
                                                                        sampleFileName="MMNi.dat"):
    """
    CalcAbsorptionCoeff
    @retval EC
    """
    if os.path.exists(sampleFileName):
        pass
    else:
        #sampleFileName = os.path.join(os.sep,"home","dnaadmin","ana","setup",sampleFileName)
        #sampleFileName = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup",sampleFileName)
        ret = SPD.CheckForInput( "setup", sampleFileName )
        if ret!="":
            sampleFileName = ret
        else:
            raise UserWarning("EneOrig::CalcAbsorptionCoeff >> sampleFileName %s is not found"%(sampleFileName))

    aa = aa * 180.0/3.14
    pa = pa * 180.0/3.14

    eiArray = [float(val) for val in eiArray.split(",")]
    EC= ACR.CalcAbsorptionCoeff(mode, eiArray, ef, aa, pa, sampleFileName)
    return EC
#--------------------------------------------------------------------------------------------------
def ExecPolyFitEC(ec=DAT,degree=4):
    """
    ExecPolyFitEC
    @retval EC
    """
    EC=ACR.ExecPolyFitEC(ec,degree)
    return EC
#--------------------------------------------------------------------------------------------------
def ExecPolyFit(xarray,yarray,degree):
    return ACR.ExecPolyFit(xarray,yarray,degree)
#--------------------------------------------------------------------------------------------------
def PolyFunction(xarray,param):
    return ACR.PolyFunction(xarray,param)
###################################################################################################
# Absorption Correction (exec correction)
###################################################################################################
def DoAbsorptionCorrectionWithoutCellData(ecm=ECM,filename="input.ass"):
    """
    DoAbsorptionCorrectionWithoutCellData
    @retval DAT
    """
    if os.path.exists(filename):
        pass
    else:
        #filename = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",filename)
        #filename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",filename)
        ret = SPD.CheckForInput( "Absorb", filename )
        if ret!="":
            filename = ret
        else:
            raise UserWarning("EneOrig::DoAbsorptionCorrectionWithoutCellData >> filename %s is not found"%(filename))

    DAT = ACR.DoAbsorptionCorrectionWithoutCellData(ecm,filename)
    return DAT
#-------------------------------------------------------------------------------------------------
def DoAbsorptionCorrectionCellData(ECM_I_C_C=ECM2, 
                              AcscFname="input.acsc", AccFname="input.acc", AsscFname="input.assc"):
    """
    DoAbsorptionCorrectionWithCellData
    @retval DAT
    """
    if os.path.exists(AcscFname):
        pass
    else:
        #AcscFname = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",AcscFname)
        #AcscFname = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",AcscFname)
        ret = SPD.CheckForInput( "Absorb", AcscFname )
        if ret!="":
            AcscFname = ret
        else:
            raise UserWarning("EneOrig::DoAbsorptionCorrectionWithCellData >> AcscFname %s is not found"%(AcscFname))

    if os.path.exists(AccFname):
        pass
    else:
        #AccFname = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",AccFname)
        #AccFname = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",AccFname)
        ret = SPD.CheckForInput( "Absorb", AccFname )
        if ret!="":
            AccFname = ret
        else:
            raise UserWarning("EneOrig::DoAbsorptionCorrectionWithCellData >> AccFname %s is not found"%(AccFname))

    if os.path.exists(AsscFname):
        pass
    else:
        #AsscFname = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",AsscFname)
        #AsscFname = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",AsscFname)
        ret = SPD.CheckForInput( "Absorb", AsscFname )
        if ret!="":
            AsscFname = ret
        else:
            raise UserWarning("EneOrig::DoAbsorptionCorrectionWithCellData >> AsscFname %s is not found"%(AsscFname))

    DAT = ACR.DoAbsorptionCorrectionCellData(ECM_I_C_C,AcscFname,AccFname,AsscFname)
    return DAT
#-------------------------------------------------------------------------------------------------
def DoAbsorptionCorrectionWithCellData(ECM_I_SC_SC=ECM1, ECM_I_C_C=ECM2, 
                              AcscFname="input.acsc", AccFname="input.acc", AsscFname="input.assc"):
    """
    DoAbsorptionCorrectionWithCellData
    @retval DAT
    """
    if os.path.exists(AcscFname):
        pass
    else:
        #AcscFname = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",AcscFname)
        #AcscFname = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",AcscFname)
        ret = SPD.CheckForInput( "Absorb", AcscFname )
        if ret!="":
            AcscFname = ret
        else:
            raise UserWarning("EneOrig::DoAbsorptionCorrectionWithCellData >> AcscFname %s is not found"%(AcscFname))

    if os.path.exists(AccFname):
        pass
    else:
        #AccFname = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",AccFname)
        #AccFname = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",AccFname)
        ret = SPD.CheckForInput( "Absorb", AccFname )
        if ret!="":
            AccFname = ret
        else:
            raise UserWarning("EneOrig::DoAbsorptionCorrectionWithCellData >> AccFname %s is not found"%(AccFname))

    if os.path.exists(AsscFname):
        pass
    else:
        #AsscFname = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",AsscFname)
        #AsscFname = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",AsscFname)
        ret = SPD.CheckForInput( "Absorb", AsscFname )
        if ret!="":
            AsscFname = ret
        else:
            raise UserWarning("EneOrig::DoAbsorptionCorrectionWithCellData >> AsscFname %s is not found"%(AsscFname))

    DAT = ACR.DoAbsorptionCorrectionWithCellData(ECM_I_SC_SC,ECM_I_C_C,AcscFname,AccFname,AsscFname)
    return DAT
#-------------------------------------------------------------------------------------------------
def DoAbsorptionCorrectionOfElastic(dat=ECM,filename="input.ele"):
    """
    DoAbsorptionCorrectionWithCellData
    @retval DAT
    """
    if os.path.exists(filename):
        pass
    else:
        #filename = os.path.join(os.sep,"home","dnaadmin","ana","Absorb",filename)
        #filename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Absorb",filename)
        ret = SPD.CheckForInput( "Absorb", filename )
        if ret!="":
            filename = ret
        else:
            raise UserWarning("EneOrig::DoAbsorptionCorrectionOfElastic >> filename %s is not found"%(filename))

    DAT = ACR.DoAbsorptionCorrectionOfElastic(dat,filename)
    return DAT
###################################################################################################
# Calc scattering cross section
###################################################################################################
def GetCrossSection(container="sample", sample_filename="MMVana.dat", nist_filename="all_nist_data.dat"):
    """
    GetCrossSection
    @retval VAL
    """
    if os.path.exists(nist_filename):
        pass
    else:
        #nist_filename = os.path.join(os.sep,"home","dnaadmin","ana","setup","database",nist_filename)
        #nist_filename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup","database",nist_filename)
        if "UTSUSEMI_USR_PRIV_HOME" in os.environ:
            nist_filename = os.path.join( os.environ["UTSUSEMI_USR_DIR"],
                                          os.environ["UTSUSEMI_SYS_NAME"],
                                          "ana","database" )
        else:
            nist_filename = os.path.join( os.environ["UTSUSEMI_BASE_DIR"],
                                          os.environ["UTSUSEMI_INST_CODE"],
                                          "ana","database" )
        if not os.path.exists( nist_filename ):
            raise UserWarning("Nist file does not found (%s)"%(nist_filename))

    if os.path.exists(sample_filename):
        pass
    else:
        #sample_filename = os.path.join(os.sep,"home","dnaadmin","ana","setup",sample_filename)
        #sample_filename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup",sample_filename)
        sample_filename = SPD.CheckForInput( "setup",sample_filename )
        if sample_filename=="":
            raise UserWarning("sample file does not found (%s)"%(sample_filename))

    VAL=EFC.GetCrossSection(container, sample_filename, nist_filename)
    print("cross section :",VAL)
    return VAL
#-------------------------------------------------------------------------------------------------
def GetCrossSectionScaleFactor(dat=ECM, energyMin=-0.01, energyMax=0.01,
                               container1="sample", sample_filename1="MMVana.dat", nist_filename="all_nist_data.dat"):
    """
    GetCrossSection
    @retval VAL
    """
    if os.path.exists(nist_filename):
        pass
    else:
        #nist_filename = os.path.join(os.sep,"home","dnaadmin","ana","setup","database",nist_filename)
        #nist_filename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup","database",nist_filename)
        if "UTSUSEMI_USR_PRIV_HOME" in os.environ:
            nist_filename = os.path.join( os.environ["UTSUSEMI_USR_DIR"],
                                          os.environ["UTSUSEMI_SYS_NAME"],
                                          "ana","database" )
        else:
            nist_filename = os.path.join( os.environ["UTSUSEMI_BASE_DIR"],
                                          os.environ["UTSUSEMI_INST_CODE"],
                                          "ana","database" )
        if not os.path.exists( nist_filename ):
            raise UserWarning("Nist file does not found (%s)"%(nist_filename))

    if os.path.exists(sample_filename1):
        pass
    else:
        #sample_filename1 = os.path.join(os.sep,"home","dnaadmin","ana","setup",sample_filename1)
        #sample_filename1 = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","setup",sample_filename1)
        sample_filename = SPD.CheckForInput( "setup",sample_filename )
        if sample_filename=="":
            raise UserWarning("sample file does not found (%s)"%(sample_filename))

    VAL = EFC.PutCrossSectionScaleFactor(dat, energyMin, energyMax,
                                         container1, sample_filename1, nist_filename)
    print("coss section scale factor :",VAL)
    return VAL
#-------------------------------------------------------------------------------------------------
def GetAverage(dat=ECM, energyMin=-0.01, energyMax=0.01):
    """
    GetAverage
    @retval VAL
    """
    VAL = EFC.PutAverage(dat, energyMin, energyMax)
    return VAL
###################################################################################################
# Efficiency Correction
###################################################################################################
def CreateMaskFileFromAverageIntensity(dat=ECM, energyMin=-0.01, energyMax=0.01, output="newMask.txt", thresh=0.5):
    """
    CreateMaskFileFromAverageIntensity
    @retval None
    """
    #output = os.path.join(os.sep,"home","dnaadmin","ana","Mask",output) # Modify [Matsuura 20150414]
    #output = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Mask",output)
    ret = SPD.CheckForOutput( "Mask" )
    if ret=="":
        raise UserWarning("CreateMaskFileFromAverageIntensity >> Not found Mask directory")
    else:
        output = os.path.join(os.sep, ret, output )
    return EFC.CreateMaskFileFromAverageIntensity(dat,energyMin,energyMax,output,thresh)
#-------------------------------------------------------------------------------------------------
def CreateEfficiencyFile(dat=ECM, energyMin=-0.01, energyMax=0.01, output="newEff.txt"):
    """
    CreateEfficiencyFile
    @retval None
    """
    #output = os.path.join(os.sep,"home","dnaadmin","ana","Efficiency",output)
    #output = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Efficiency",output)
    ret = SPD.CheckForOutput( "Efficiency" )
    if ret=="":
        raise UserWarning("CreateEfficiencyFile >> Not found Efficiency directory" )
    else:
        output = os.path.join(os.sep,ret,output)
    return EFC.CreateEfficiencyFile(dat,energyMin,energyMax,output)
#-------------------------------------------------------------------------------------------------
def DoEfficiencyCorrection(dat=ECM,filename="Eff.txt",mode=1):
    """
    DoEfficiencyCorrection
    @retval DAT
    """
    #filename = os.path.join(os.sep,"home","dnaadmin","ana","Efficiency",filename)
    #filename = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Efficiency",filename)
    ret = SPD.CheckForOutput( "Efficiency" )
    if ret=="":
        raise UserWarning("DoEfficiencyCorrection >> Not found Efficiency directory")
    else:
        filename = os.path.join(os.sep, ret, filename)
    DAT = EFC.DoEfficiencyCorrection(dat,filename,mode)
    return DAT
#-------------------------------------------------------------------------------------------------
def DoCrossSectionScaleFactorCorrection(dat=ECM,scalefactor=1.0,sampleMass=1.0,unitMass=1.0):
    """
    DoCrossSectionScaleFactorCorrection
    @retval DAT
    """
    DAT = EFC.DoCrossSectionScaleFactorCorrection(dat,scalefactor,sampleMass,unitMass)
    return DAT
#-------------------------------------------------------------------------------------------------
def DeleteMask_DirectBeam(input="Mask.txt", output="newMask.txt"):
    """
    DeleteMask_DirectBeam
    @retval None
    """
    #filename1 = os.path.join(os.sep,"home","dnaadmin","ana","Mask",input)
    #filename2 = os.path.join(os.sep,"home","dnaadmin","ana","Mask",output)
    #filename1 = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Mask",input)
    #filename2 = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Mask",output)
    filename1 = ""
    filename2 = ""
    ret = SPD.CheckForInput( "Mask", input )
    if ret=="":
        raise UserWarning("DeleteMask_DirectBeam >> Not found input file (%s)"%(input))
    else:
        filename1 = ret

    ret = SPD.CheckForOutput( "Mask" )
    if ret=="":
        raise UserWarning("DeleteMask_DirectBeam >> Not found Mask directory")
    else:
        filename2 = os.path.join(os.sep, ret, output )
    return EFC.DeleteMask_DirectBeam(filename1,filename2)
#-------------------------------------------------------------------------------------------------
def DeleteMask_Spurious(input="Mask.txt", output="newMask.txt"):
    """
    DeleteMask_Spurious
    @retval None
    """
    #filename1 = os.path.join(os.sep,"home","dnaadmin","ana","Mask",input)
    #filename2 = os.path.join(os.sep,"home","dnaadmin","ana","Mask",output)
    #filename1 = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Mask",input)
    #filename2 = os.path.join(os.sep,os.environ["UTSUSEMI_USR_PRIV_HOME"],"ana","Mask",output)
    filename1 = ""
    filename2 = ""
    ret = SPD.CheckForInput( "Mask", input )
    if ret=="":
        raise UserWarning("DeleteMask_Spurious >> Not found input file (%s)"%(input))
    else:
        filename1 = ret

    ret = SPD.CheckForOutput( "Mask" )
    if ret=="":
        raise UserWarning("DeleteMask_Spurious >> Not found Mask directory")
    else:
        filename2 = os.path.join(os.sep, ret, output )
    return EFC.DeleteMask_Spurious(filename1,filename2)

###################################################################################################
# Pylab Plot Tools
###################################################################################################
def EcmIntensity2TwoLayerArray(dat):
    return PPT.EcmIntensity2TwoLayerArray(dat)
#-------------------------------------------------------------------------------------------------
def PylabPlotTwoLayerArray(varray, xregion, yregion, zregion):
    return PPT.PylabPlotTwoLayerArray(varray, xregion, yregion, zregion)

#########################################
# Dictionary for entry the name of functions
_functions = {"MovingAverage":MovingAverage,
              "CalcTOFOffset":CalcTOFOffset,
              "ExecGaussFitEC":ExecGaussFitEC,
              "CalcASS":CalcASS,
              "CalcACSC":CalcACSC,
              "CalcACSS":CalcACSS,
              "CalcACC":CalcACC,
              "CalcASSOfElastic":CalcASSOfElastic,
              "CalcAbsorptionCoeff":CalcAbsorptionCoeff,
              "ExecPolyFitEC":ExecPolyFitEC,
              "DoAbsorptionCorrectionWithoutCellData":DoAbsorptionCorrectionWithoutCellData,
              "DoAbsorptionCorrectionWithCellData":DoAbsorptionCorrectionWithCellData,
              "DoAbsorptionCorrectionOfElastic":DoAbsorptionCorrectionOfElastic,
              "DoAbsorptionCorrectionCellData":DoAbsorptionCorrectionCellData, 
              "GetCrossSection":GetCrossSection,
              "GetCrossSectionScaleFactor":GetCrossSectionScaleFactor,
              "GetAverage":GetAverage,
              "CreateMaskFileFromAverageIntensity":CreateMaskFileFromAverageIntensity,
              "CreateEfficiencyFile":CreateEfficiencyFile,
              "DoEfficiencyCorrection":DoEfficiencyCorrection,
              "DoCrossSectionScaleFactorCorrection":DoCrossSectionScaleFactorCorrection,
              "DeleteMask_DirectBeam":DeleteMask_DirectBeam,
              "DeleteMask_Spurious":DeleteMask_Spurious
             }
