# -*- coding: utf-8 -*-
#
# $Date: 2012-08-20 17:49:07 +0900 (月, 20 8 2012) $
# $Rev: 2 $
#
import wx
from wx import xrc

import os

class FileNotFound(Exception):
    def __init__(self, filename):
        self.filename = filename
        return

    def __str__(self):
        return repr(self.filename)

class ControlNotFound(Exception):
    def __init__(self, name):
        self.name = name
        return

    def __str__(self):
        return 'name: ' + repr(self.name)

class XrcBase(object):
    __resources = dict()

    @staticmethod
    def getResource(filename):
        fullpath = os.path.join(os.path.abspath(os.path.dirname(__file__)), '../../')
        fullpath = os.path.join(fullpath, filename)

        if not os.path.exists(fullpath):
            raise FileNotFound(fullpath)

        if filename in XrcBase.__resources:
            resource = XrcBase.__resources[filename]
            pass
        else:
            resource = xrc.EmptyXmlResource()
            resource.Load(filename)
            XrcBase.__resources[filename] = resource
            pass

        return resource

    def getControl(self, name):
        control = xrc.XRCCTRL(self, name)

        if control == None:
            raise ControlNotFound(name)
        return control

    def setNumberInput(self, name):
        obj=self.getControl(name)

        if "SetValue" in dir(obj):
            obj.Bind(wx.EVT_TEXT,self.checkNumberInput)

    def checkNumberInput(self,event):       # テキストコントロールに数字だけ入力モードにする。
        obj=event.GetEventObject()
        text=obj.GetValue()
        if len(text)!=0: 
            condition  = text[-1].isdigit() # isdigit
            condition += text[-1]=="."      # とりあえず可 OR
            condition += text[-1]=="+"      #           OR
            condition += text[-1]=="-"      #           OR
            condition += text[-1]=="e"      #           OR
            condition += text[-1]=="E"      #           OR
            #AND
            condition *=text.count(".")<2   # 2個以上は不可
            condition *=text.count("e")<2
            condition *=text.count("E")<2
            #AND
            if text[-1]=="+":
                if len(text)==1:            # 最初は可
                    condition *=True
                else:
                    if text[-2]=="e" or text[-2]=="E": # Eの次でも可
                        condition *=True
                    else:
                        condition *=False
            #AND
            if text[-1]=="-":
                if len(text)==1:            # 最初は可
                    condition *=True
                else:
                    if text[-2]=="e" or text[-2]=="E": # Eの次でも可
                        condition *=True
                    else:
                        condition *=False

            if condition > 0:
                pass
            else:
                if len(text)!=0:
                    obj.SetValue(text[:-1])


class FrameBase(XrcBase, wx.Frame):
    def __init__(self, filename, frameName):
        resource = XrcBase.getResource(filename)

        pre = wx.PreFrame()
        resource.LoadOnFrame(pre, None, frameName)
        self.PostCreate(pre)
        return

class DialogBase(XrcBase, wx.Dialog):
    def __init__(self, parent, filename, dialogName):
        resource = XrcBase.getResource(filename)

        pre = wx.PreDialog()
        resource.LoadOnDialog(pre, parent, dialogName)
        self.PostCreate(pre)
        self.CenterOnParent()
        return

class PanelBase(XrcBase, wx.Panel):
    def __init__(self, parent, filename, panelName):
        resource = XrcBase.getResource(filename)

        pre = wx.PrePanel()
        resource.LoadOnPanel(pre, parent, panelName)
        self.PostCreate(pre)
        return
