#!/usr/bin/python

from __future__ import print_function
import math
import os
import glob
import time

start = time.time()
import sys
ver = float(sys.version_info[0])+float(sys.version_info[1])*0.1
if ver<2.5:
    from elementtree.ElementTree import ElementTree
else:
    from xml.etree.ElementTree import ElementTree

def _writeParam(val,dpath,params,att="",i=0):
    if dpath!="":
        headStr=""
        head=open(dpath)
        l=head.readline()
        if l[:2]=="<?":headStr+=l
        l=head.readline()
        if l[:2]=="<!":headStr+=l

        fd = open(dpath,'rb')
        dom=ElementTree(file=fd)
        fd.close()

        ele = dom.getroot()
        for param in params:
            if param==params[-1]:
                ele = ele.findall(param)
            else:
                ele = ele.find(param)
        valStr=str(val)

        if att=="":
            ele[i].text=valStr
        else:
            ele[i].set(att,valStr)
        dom.write(dpath)

        allline=open(dpath,"r").read()

        f = open(dpath,"w")
        f.write(headStr)
        for line in allline:f.write(line)
        f.close()

def _readParam(dpath,params,att="",i=0):
    if dpath!="":
        fd = open(dpath,'rb')
        dom=ElementTree(file=fd)
        fd.close()

        ele = dom.getroot()
        for param in params:
            if param==params[-1]:
                ele = ele.findall(param)
            else:
                ele = ele.find(param)

        if att=="":
            return ele[i].text
        else:
            return ele[i].get(att)


def _writeBinInfo(filename,initial,end,width,separator):
    f = open(filename,"w")
    i=0
    while 1:
        val =  initial + i*width
        if val >end:
            break
        f.write(str(val) + separator)
        i+=1
    f.close()

def _readBinInfo(filename,separatorIn,separatorOut):
    f = open(filename,"r")
    lines = f.read().split(separatorIn)

    lines = [line for line in lines if line !=""]

    for i,line in enumerate(lines):
        print("  "+str(i)+"\t"+line)

    text  = separatorOut.join(lines)
    f.close()
    return text

#initial  = -1.0
#end      =  1.0
#width    =  0.1
#separator =  "\n"
#filename = "binInfo2.txt"
#_writeBinInfo(filename,initial,end,width,separator)

#separatorIn  =  "\n"
#separatorOut =  ","

#ret=_readBinInfo(filename,separatorIn,separatorOut)

#print ret
