#ifndef UTSUSEMIFILTERTRIGNETCONDITIONDNA
#define UTSUSEMIFILTERTRIGNETCONDITIONDNA
#include "Header.hh"
#include <algorithm>
//////////////////////////////////
// UtsusemiFilterTrignetConditionDNA
/////////////////////////////////
class UtsusemiFilterTrignetConditionDNA
{
protected:
    Double fastChopperFrequency;

    UInt4 fastChopperNumOfSlit;

    std::vector<Double> fastChopperSlitWidths;

    std::vector<Double> fastChopperSlitAngles;

    UInt4 fastChopperMode;

    Double LChopper;

    Double LBand;

    Double L1;

    Double TOFminSource;

    Double TOFmaxSource;

    Double LambdaCenter;

    Double DeltaLambda;

    Double LambdaMin;

    Double LambdaMax;

    Double TOFoffset;

    Double TOFresolver1;

    Double TOFresolver2;

    std::vector<Double> _CalcTOFSlit();

    std::vector<std::vector<Double> > _CalcTOFSlit(std::vector<std::vector<UInt4> >, std::vector<Double>);

    std::vector<std::vector<Double> > _CalcTOFSlit(std::vector<std::vector<UInt4> >,std::vector<std::vector<UInt4> >, std::vector<Double>);


    std::vector<Double> _eiRange;

    std::vector<Double> _tofRange;

    std::vector<Double> _tofSlit;

public:
    UtsusemiFilterTrignetConditionDNA();

    ~UtsusemiFilterTrignetConditionDNA();

    std::vector<Double> CalcBandRange();

    std::vector<std::vector<Double> > CalcTOFRange(std::vector<std::vector<Double> > ChopperCaseTablesIn); // --old

    std::vector<std::vector<Double> > CalcTOFRange(std::vector<std::vector<UInt4> >, std::vector<Double>);

    std::vector<std::vector<Double> > CalcTOFRange(std::vector<std::vector<UInt4> >,std::vector<std::vector<UInt4> >, std::vector<Double>);

    std::vector<Double> CalcTOFRange();

    std::vector<Double> CalcEiRange();

    std::vector<std::vector<Double> > CalcTOFRangeDebug(std::vector<std::vector<Double> > ChopperCaseTablesIn);

    std::vector<std::vector<Double> > CalcTOFSlit(std::vector<std::vector<UInt4> >, std::vector<Double>);

    std::vector<std::vector<Double> > CalcTOFSlit(std::vector<std::vector<UInt4> >,std::vector<std::vector<UInt4> >, std::vector<Double>);

    std::vector<Double> CalcTOFSlit();

    std::vector<Double> GetTOFRange();

    std::vector<Double> GetEiRange();

    std::vector<Double> GetTOFSlit();

    std::vector<Double> CalcEiShift();

    void Clear();
};

#endif
