#ifndef CONGERGENCE_STAT
#define CONGERGENCE_STAT

//#ifdef SWIGPYTHON
//class AdvConvergenceStat ;
//#else // SWIGPYTHON

#include <deque>

#include "Header.hh"
//#include "SemaphoreControll.hh"

#include "AdvParamSet.hh"
#include "AdvLevmarConsts.hh"
#include "AdvLevmarImmutables.hh"

#define USE_PTHREAD

#ifdef USE_PTHREAD

//#define USE_RWLOCK
#ifndef USE_RWLOCK

#define USE_MUTEX

#endif // USE_RWLOCK

#endif //  USE_PTHREAD

/**
 *  the queue (first-ini/first-out buffer) for states while the fitting process
 */
class AdvConvergenceStat : public AdvMessage {
    private:
        static const string className; // =string("LevmarAdvConvergenceStat");

    private:
        /** history buffer capacity */
        UInt4 capacity;

#ifdef USE_PTHREAD
#ifdef USE_MUTEX
        pthread_mutex_t mutex;
#endif // USE_MUTEX
#ifdef USE_RWLOCK
        //pthread_rwlock_t rwlock;
#endif // USE_RWLOCK
        pthread_cond_t  guard;
#endif // USE_PTHREAD
        deque<AdvParamSet*> q;

    public:
        /** constructor */
        AdvConvergenceStat();
        /** constructor */
        AdvConvergenceStat(UInt4 capacity);
        /** destructor */
        ~AdvConvergenceStat();

        //void lock() ;
        //void unlock();

        /** true, if the queuq is empty */
        Bool empty();
        /** size of stat entries in the queue*/
        UInt4 size();
        /** push the latest stat in the queue. */
        void push(AdvParamSet *param);
        /** pop the earliest stat from the queue. */
        AdvParamSet *pop();
        /** refer the earliest stat in the queue. */
        AdvParamSet *referEarliestStat();
        /** refer the latest stat in the queue. */
        AdvParamSet *referLatestStat();

        AdvParamSet *at(UInt4 i);

};

//#endif // SWIGPYTHON

#endif // CONGERGENCE_STAT
