#ifndef FUNCCOMB_H
#define FUNCCOMB_H

#include <stdexcept>

#include "Header.hh"
#include "CppToPython.hh"

#include "AdvMessage.hh"
#include "AdvFuncBase.hh"
#include "AdvFuncParser.hh"

class AdvFuncComb : public AdvMessage {

    private:
        static const string className;

    private:
        /** a list of functions */
        vector<AdvFuncBase*> funcList;
        /** a list of values of paramters for each functions */
        vector< vector<Double> > paramArray;
        /** a list of values of paramter errors for each functions */
        vector< vector<Double> > errorArray;

        vector<Double> linkList;

    private:
        void setFuncList(const vector<AdvFuncBase*> funcList) throw(invalid_argument);
        void setFuncList(const string                expr);
        void setLinkList(const vector<Double> linkList);
        //void setParamList(                                     );
        void setParamList(const vector<Double>       &paramList);
        void setParamList(PyObject                   *paramList);
        void setErrorList(                                     );
        void setErrorList(const vector<Double>       &errorList);
        void setErrorList(PyObject                      *PyList);
        void setErrorList(const vector< vector<Double> > &covar);

        Bool checkNumberOfParam(const vector<Double> &list) const ;
        Bool checkNumberOfParam(const vector< vector<Double> > &covar) const ;
        vector< vector<Double> > vectorToArray(const vector<Double> &list);

        /** inner product of two vectors */
        Double innerProduct(const vector<Double> &x, const vector<Double> &y);

    public:
        AdvFuncComb();
        /* */
        AdvFuncComb(const vector<AdvFuncBase*> funcList);

        AdvFuncComb(const vector<AdvFuncBase*> funcList,const string lk, const vector<Double>);

        AdvFuncComb(const string            expr);

        /** constructor */
        AdvFuncComb(const vector<AdvFuncBase*> fList, const vector<Double> param);

        //AdvFuncComb(const vector<AdvFuncBase*> fList, const vector<Double> param);
        AdvFuncComb(const string             expr, PyObject            *param);
        /** constructor */
        AdvFuncComb(const vector<AdvFuncBase*> fList, const vector<Double> param, const vector< vector<Double> > &covar);
        /** constructor */
        AdvFuncComb(const vector<AdvFuncBase*> fList, const vector<Double> param, const vector<Double> errorList);
        AdvFuncComb(const string            expr,  PyObject            *param, PyObject            *errorList);
        /** destructor */
        ~AdvFuncComb();

       void set(const vector<AdvFuncBase*> funcList, const vector<Double> paramList);
       //void set(const string expr, PyObject *list);
   
       void set(const vector<AdvFuncBase*> funcList, const vector<Double> &paramList, const vector< vector<Double> > &covar);
       void set(const string expr, PyObject *paramList, PyObject *errorList);
       void set(const vector<AdvFuncBase*> funcList, const vector<Double> &paramList, const vector<Double> &errorList);

       void set(const vector<Double> &p                         ) throw(invalid_argument);
       void set(const vector<Double> &p, const vector<Double> &e) throw(invalid_argument);
       void set(PyObject             *p                         ) throw(invalid_argument);
       void set(PyObject             *p, PyObject             *e) throw(invalid_argument);
       void setError(const vector<Double> &e) throw(invalid_argument);
       void setError(PyObject             *e) throw(invalid_argument);

       /** add a function and its parameters */
       void add(AdvFuncBase *func, const vector<Double> &paramList);
       /** add a function, its parameters and paremter errors */
       void add(AdvFuncBase *func, const vector<Double> &paramList, const vector<Double> &errorList);
       /** erace the i-th. component */
       void erase(UInt4 i);

       /** dump function components */
       void dump();

       /** get the number of function components */
       UInt4 getNumberOfComponents() const ;
       /** get the name of the i-th. function component */
       string getName(UInt4 i) const ;
       /** get the symbol of the i-th. function component */
       string getSymbol(UInt4 i) const ;
       /** get the number of required parameters */
       UInt4 getNumberOfRequiredParam() const ;
       /** get the number of required parameters for the i-th. function component */
       UInt4 getNumberOfRequiredParam(UInt4 i) const ;

       /** get parameters for i-th. component of the function */
       vector<Double> getSubsequenceOfParam(UInt4 i);
       /** get parameter errors for i-th. component of the function */
       vector<Double> getSubsequenceOfParamError(UInt4 i);

       /** evaluate the error value of the function at the given point */
       Double evalComponent(const Double x, const UInt4 i);
#ifdef HAVE_DIFFERENTIAL_MEMBER
       /** evaluage the 1st derivative coefficient of the function component at the given point */
       Double der1stComponent(const Double x, const UInt4 i);
       /** evaluage the 2nd derivative coefficient of the function component at the given point */
       Double der2ndComponent(const Double x, const UInt4 i);
       /** evaluate the gradient of the function component from parameters at the given point */
       vector<Double> gradientComponent(const Double x, const UInt4 i);
       /** evaluate the error of the function component from parameters at the given point */
       Double evalErrorComponent(const Double x, const UInt4 i);
#endif // HAVE_DIFFERENTIAL_MEMBER

       /** evaluate the value of the function at the given point */
       Double eval(const Double x);
#ifdef HAVE_DIFFERENTIAL_MEMBER
       Double der1st(const Double x);
       Double der2nd(const Double x);
       vector<Double> gradient(const Double x);
       /** evaluate the error value of the function from parameters at the given point */
       Double evalError(const Double x);
#endif // HAVE_DIFFERENTIAL_MEMBER

       /** evaluate the lisf of the error value for the function at the given points */
       vector<Double> evalComponent(const vector<Double> &x, const UInt4 i);
#ifdef HAVE_DIFFERENTIAL_MEMBER
       vector<Double> der1stComponent(const vector<Double> &x, const UInt4 i);
       vector<Double> der2ndComponent(const vector<Double> &x, const UInt4 i);
       vector< vector<Double> > gradientComponent(const vector<Double> &x, const UInt4 i);
       /** evaluate the list of the error of the function component from parameters at the given points*/
       vector<Double> evalErrorComponent(const vector<Double> &x, UInt4 i);
#endif // HAVE_DIFFERENTIAL_MEMBER


       /** evaluate the list of the function's values at the given points */
       vector<Double> eval(const vector<Double> &x);
#ifdef HAVE_DIFFERENTIAL_MEMBER
       vector<Double> der1st(const vector<Double> &x);
       vector<Double> der2nd(const vector<Double> &x);
       vector< vector<Double> > gradient(const vector<Double> &x);
       /** evaluate the list of the error for the function from parameters at the given points */
       vector<Double> evalError(const vector<Double> &x);
#endif // HAVE_DIFFERENTIAL_MEMBER

};
#endif
