#include "AdvSmoothing.hh"


/**
 *  class name
 */
const std::string AdvSmoothing::className=std::string("AdvSmoothing");

/**
 *  default constructor
 */
AdvSmoothing::AdvSmoothing() {
};

AdvSmoothing::AdvSmoothing(ElementContainer *src) : AdvOperationBase(src) {
}

/**
 *  constructor
 */
#ifndef SWIGPYTHON
AdvSmoothing::AdvSmoothing(ElementContainer *src, AdvMethod *method) : AdvOperationBase(src, method) {
}
#endif

AdvSmoothing::AdvSmoothing(ElementContainer *src, const AdvMethodType &methodType) : AdvOperationBase(src, methodType) {
}

AdvSmoothing::AdvSmoothing(ElementContainer *src, const std::string &methodName) : AdvOperationBase(src, methodName) {
}

/**
 *  constructor
 */
#ifndef SWIGPYTHON
AdvSmoothing::AdvSmoothing(ElementContainer *src, AdvMethod *method, const Double xLower, const Double xUpper) : AdvOperationBase(src, method, xLower, xUpper) {
}
#endif

AdvSmoothing::AdvSmoothing(ElementContainer *src, const AdvMethodType &methodType, const Double xLower, const Double xUpper) : AdvOperationBase(src, methodType, xLower, xUpper) {
}

AdvSmoothing::AdvSmoothing(ElementContainer *src, const std::string &methodName, const Double xLower, const Double xUpper) : AdvOperationBase(src, methodName, xLower, xUpper) {
}

/**
 *  constructor
 */
#ifndef SWIGPYTHON
AdvSmoothing::AdvSmoothing(ElementContainer *src, AdvMethod *method, const UInt4 lower, const UInt4 upper) : AdvOperationBase(src, method, lower, upper) {
}
#endif

AdvSmoothing::AdvSmoothing(ElementContainer *src, const AdvMethodType &methodType, const UInt4 lower, const UInt4 upper) : AdvOperationBase(src, methodType, lower, upper) {
}

AdvSmoothing::AdvSmoothing(ElementContainer *src, const std::string &methodName, const UInt4 lower, const UInt4 upper) : AdvOperationBase(src, methodName, lower, upper) {
}



/**
 *  destructor
 */
AdvSmoothing::~AdvSmoothing() {
}


Double AdvSmoothing::chiSq() {
    return 0.0;
}


void AdvSmoothing::execute() {

    if ( this->method->checkParam(*(this->source), domain, param) ) {
        this->method->toInnerForm(*(this->source), domain, param);
        this->method->fit();
        this->method->eval();
    }

}


