#include "AdvSimulatedAnnealingConsts.hh"

const std::string AdvSimulatedAnnealingConsts::className=std::string("AdvSimulatedAnnealingConsts");

/**
 *  keys for contrioling AdvSimulatedAnnealingConsts
 */
/** key for the kind of the constrain */
const std::string AdvSimulatedAnnealingConsts::CONSTRAIN         =std::string("constrain");

/** key for the flag of using data weights */
const std::string AdvSimulatedAnnealingConsts::USE_DATA_WEIGHTS=std::string("use data weights");

/** key for output interval */
const std::string AdvSimulatedAnnealingConsts::OUTPUT_INTERVAL = std::string("output interval");

/** key for simulated annealing */
const std::string AdvSimulatedAnnealingConsts::N_TRIES       = std::string("n_tries");
const std::string AdvSimulatedAnnealingConsts::ITERS_FIXED_T = std::string("iters_fixed_t");
const std::string AdvSimulatedAnnealingConsts::STEP_SIZE     = std::string("step_size");
const std::string AdvSimulatedAnnealingConsts::K             = std::string("k");
const std::string AdvSimulatedAnnealingConsts::T_INITIAL     = std::string("t_initial");
const std::string AdvSimulatedAnnealingConsts::MU_T          = std::string("mu_t");
const std::string AdvSimulatedAnnealingConsts::T_MIN         = std::string("t_min");

/**
 *  key for input data for fitting using AdvSimulatedAnnealingConsts
 */
/** key for fitting function */
const std::string AdvSimulatedAnnealingConsts::FUNCTIONS= std::string("functions");

/** keys for a set of values of fitting parameters */
const std::string AdvSimulatedAnnealingConsts::INITIAL_PARAM_VALUES=std::string("initial param values");

const std::string AdvSimulatedAnnealingConsts::PARAMETER_VALUES    =std::string("parameter values");

/** key for a set of the refference data */
const std::string AdvSimulatedAnnealingConsts::REFERENCE_VALUES  =std::string("reference values");

/** keys for lower bound of box constrains */
const std::string AdvSimulatedAnnealingConsts::LOWER_BOUNDS      =std::string("lower bounds");
/** keys for upper bound of box constrains */
const std::string AdvSimulatedAnnealingConsts::UPPER_BOUNDS      =std::string("upper bounds");
/** key for weights of box constrains */
const std::string AdvSimulatedAnnealingConsts::BOX_WEIGHTS       =std::string("box weights");

/** key for current iterations */
const std::string AdvSimulatedAnnealingConsts::ITERATION_COUNT    =std::string("iteration count");
/** key for parameter errors */
const std::string AdvSimulatedAnnealingConsts::PARAM_ERRORS       =std::string("param errors");

/** the number times of function evaluations */
const std::string AdvSimulatedAnnealingConsts::FUNCTION_EVALUATIONS  = std::string("function evaluations");
/** iteration time */
const std::string AdvSimulatedAnnealingConsts::ITERATION_TIME= std::string("iteration time");

/*
 *  default values of parametes with keys
 */
/** default constrain */
const AdvSimulatedAnnealingConsts::Constrain  AdvSimulatedAnnealingConsts::DEFAULT_CONSTRAIN=AdvSimulatedAnnealingConsts::BOX;

/** default value of the flag to fit with weight */
const Bool               AdvSimulatedAnnealingConsts::DEFAULT_USE_DATA_WEIGHTS  =true;

/** default value for output interval */
const UInt4              AdvSimulatedAnnealingConsts::DEFAULT_OUTPUT_INTERVAL =1000U;

const Int4               AdvSimulatedAnnealingConsts::DEFAULT_N_TRIES       = 200;
const Int4               AdvSimulatedAnnealingConsts::DEFAULT_ITERS_FIXED_T = 1000;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_STEP_SIZE     = 1.0;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_K             = 1.0;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_T_INITIAL     = 0.008;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_MU_T          = 1.003;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_T_MIN         = 2.0e-6;

/** constrain std::string */
const std::string AdvSimulatedAnnealingConsts::CONSTRAIN_STR[] = {
    "no constrain",                                  // NO_CONSTRAIN
    "box",                                           // BOX
};

/** termination reason */
//const std::string AdvSimulatedAnnealingConsts::TERMINATION_REASON[] = {
//    "",  // 0
//    "",  // 1
//    "",  // 2
//    "",  // 3
//    "",  // 4
//    "",  // 5
//    "",  // 6
//    "",  // 7
//    "continue",            // 8
//    "force-quit by user",  // 9
//    "suspend",             // 10
//};

