#include "AdvPolynomial3.hh"

#define NumberOfParamForPolynomial3 1

AdvPolynomial3::AdvPolynomial3() : AdvFuncBase(std::string("polynomial3"), std::string("p3"), NumberOfParamForPolynomial3)  {
}

AdvPolynomial3::~AdvPolynomial3() {
}

#ifdef USE_POINTER
Double AdvPolynomial3::eval(const Double x, const Double *p) {
    return p[0]*x*x*x;
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvPolynomial3::der1st(const Double x, const Double *p) {
    return 3*p[0]*x*x;
}

Double AdvPolynomial3::der2nd(const Double x, const Double *p) {
    return 6*p[0]*x;
}

Double *AdvPolynomial3::gradient(const Double x, const Double *p) {
    Double *v=new Double[NumberOfParamForPolynomial3];
    v[0]=x*x*x;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
Double AdvPolynomial3::eval(const Double x, const std::vector<Double> &p) {
    return p.at(0)*x*x*x;
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvPolynomial3::der1st(const Double x, const std::vector<Double> &p) {
    return 3*p.at(0)*x*x;
}

Double AdvPolynomial3::der2nd(const Double x, const std::vector<Double> &p) {
    return 6*p.at(0)*x;
}

std::vector<Double> AdvPolynomial3::gradient(const Double x, const std::vector<Double> &p) {
    std::vector<Double> *v=new std::vector<Double>(1);
    v->at(0)=x*x*x;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

