#ifndef POLYNOMIAL1CONV_HH
#define POLYNOMIAL1CONV_HH

#include "Header.hh"
#include "AdvFuncConv.hh"
#include "AdvFuncBase.hh"

#define NumberOfParamForPolynomial1Conv 1

class AdvPolynomial1Conv : public AdvFuncBase, public AdvFuncConv{

    public:
        AdvPolynomial1Conv();
        ~AdvPolynomial1Conv();

        Double Polynomial1Func(const Double x, const Double p);
        Double Polynomial1ConvFunc(const Double x, const Double p);

#ifdef USE_POINTER
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double *p);
        Double der2nd(const Double x, const Double *p);
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        Double eval(const Double x, const std::vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const std::vector<Double> &p);
        Double der2nd(const Double x, const std::vector<Double> &p);
        std::vector<Double> gradient(const Double x, const std::vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

};
#endif // POLYNOMIAL1_HH

