#ifndef LORENTZIANCONV_H
#define LORENTZIANCONV_H 1

#include "AdvFuncBase.hh"
#include "Header.hh"
#include "OperatorBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "HeaderBase.hh"
#include "StringTools.hh"
#include "AdvFuncConv.hh"

#define NumberOfParamForLorentzianConv 3U

/**
 *  lorentzian function
 */
class AdvLorentzianConv : public AdvFuncBase, public AdvFuncConv{

    public:
         /** normarization factor 1.0/PI */

    private:
        UInt4 counter;
#ifdef USE_POINTER
        Double LorentzFunc(const Double x, const Double *p);
        Double LorentzConvFunc(const Double x, const Double *p);
#endif // USE_POINTER
#ifdef USE_VECTOR
        Double LorentzFunc(const Double x, const std::vector<Double> &p);
        Double LorentzConvFunc(const Double x, const std::vector<Double> &p);
        Double LorentzConvFuncTest(const Double x, const std::vector<Double> &p);
#endif // USE_VECTOR
    public:
        /** default constructor */
        AdvLorentzianConv() ;
        AdvLorentzianConv(const AdvLorentzianConv &);
        /** destructor */
        ~AdvLorentzianConv() ;

#ifdef USE_POINTER
        /** evaluate the value of the function */
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const Double *p);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const Double *p);
        /** evaluate the gradient of the function for parameters */
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        /** evaluate the value of the function */
        Double eval(const Double x, const std::vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const std::vector<Double> &p);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const std::vector<Double> &p);
        /** evaluate the gradient of the function for parameters */
        std::vector<Double> gradient(const Double x, const std::vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR
};

#endif
