#ifndef LORENTZIAN_H
#define LORENTZIAN_H 1

#include "AdvFuncBase.hh"

#define NumberOfParamForLorentzian 3U

/**
 *  lorentzian function
 */
class AdvLorentzian : public AdvFuncBase{

    public:
         /** normarization factor 1.0/PI */
        static const Double NC;

    private:
        Double denominator(const Double x, const Double c, const Double w, const Double n);

    public:
        /** default constructor */
        AdvLorentzian() ;
        AdvLorentzian(const AdvLorentzian &);
        /** destructor */
        ~AdvLorentzian() ;

        AdvLorentzian operator=(const AdvLorentzian &);

        /** evaluate the value of the function */
        Double eval(const Double x, const Double h, const Double c, const Double w);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const Double h, const Double c, const Double w);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const Double h, const Double c, const Double w);
        /** evaluate the value of the differential coefficient for w */
        Double derW(const Double x, const Double h, const Double c, const Double w);
#endif // HAVE_DIFFERENTIAL_MEMBER

#ifdef USE_POINTER
        /** evaluate the value of the function */
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const Double *p);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const Double *p);
        /** evaluate the gradient of the function for parameters */
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        /** evaluate the value of the function */
        Double eval(const Double x, const std::vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const std::vector<Double> &p);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const std::vector<Double> &p);
        /** evaluate the gradient of the function for parameters */
        std::vector<Double> gradient(const Double x, const std::vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR
};

#endif
