#ifndef DAMPEDHARMONICOSCILLATORCONV
#define DAMPEDHARMONICOSCILLATORCONV
#include "AdvFuncConv.hh"
#include "Header.hh"
#include "AdvFuncBase.hh"

#define NumberOfParamsForDampedHarmonicOscillatorConv 3

class AdvDampedHarmonicOscillatorConv : public AdvFuncBase, public AdvFuncConv {

    private:
        static const Double N; // =4.0/abs(atan2(0.0, -1.0))

#ifdef USE_SETTER_GETTER
    private:
        Double h;
        Double g;
        Double w0;
#endif


    public:
        AdvDampedHarmonicOscillatorConv() ;
        ~AdvDampedHarmonicOscillatorConv() ;

        /** evaluate the value of the function */
        Double DampedHarmonicOscillatorFunc(const Double x, const Double h, const Double w0, const Double g);
        Double DampedHarmonicOscillatorConvFunc(const Double x, const Double h, const Double w0, const Double g);

#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. order derivative of function */
        //Double der1st(const Double x, const Double h, const Double w0, const Double g);
        /** evaluate the value of the 2nd. order derivative of function */
        //Double der2nd(const Double x, const Double h, const Double w0, const Double g);
        /** evaluate the partial derivative of function for w0 */
        //Double derW0(const Double x, const Double h, const Double w0, const Double g);
        /** evaluate the partial derivative of function for g*/
        //Double derG(const Double x, const Double h, const Double w0, const Double g);
#endif

#ifdef USE_POINTER
        /** evaluate the value of the function */
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. order derivative of function */
        Double der1st(const Double x, const Double *p);
        /** evaluate the value of the 2nd. order derivative of function */
        Double der2nd(const Double x, const Double *p);
        /** evaluate the gradient of the function for paramters */
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        /** evaluate the value of the function */
        Double eval(const Double x, const std::vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. order derivative of function */
        Double der1st(const Double x, const std::vector<Double> &p);
        /** evaluate the value of the 2nd. order derivative of function */
        Double der2nd(const Double x, const std::vector<Double> &p);
        /** evaluate the gradient of the function for paramters */
        std::vector<Double> gradient(const Double x, const std::vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR
};

#endif
