#include "AdvConstant.hh"

#define NumberOfParamForConstant 1

AdvConstant::AdvConstant() : AdvFuncBase(std::string("constant"), std::string("c"), NumberOfParamForConstant)  {
}

AdvConstant::~AdvConstant() {
}

#ifdef USE_POINTER
Double AdvConstant::eval(const Double x, const Double *p) {
    return p[0];
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvConstant::der1st(const Double x, const Double *p) {
    return 0.0;
}

Double AdvConstant::der2nd(const Double x, const Double *p) {
    return 0.0;
}

Double *AdvConstant::gradient(const Double x, const Double *p) {
    Double *v=new Double[NumberOfParamForConstant];
    v[0]=1.0;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
Double AdvConstant::eval(const Double x, const std::vector<Double> &p) {
    return p.at(0);
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvConstant::der1st(const Double x, const std::vector<Double> &p) {
    return 0.0;
}

Double AdvConstant::der2nd(const Double x, const std::vector<Double> &p) {
    return 0.0;
}

std::vector<Double> AdvConstant::gradient(const Double x, const std::vector<Double> &p) {
    std::vector<Double> *v=new std::vector<Double>(1);
    v->at(0)=1.0;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

